#ifndef _CONNECTIONFORM_H
#define _CONNECTIONFORM_H

#include <QtGui>
#include <QtSql>
#include "Information.h"

class SavedConnection;
class MainForm;

//  ̽ Ӱ   ϴ Ŭ
class ConnectionForm : public QDialog
{
	Q_OBJECT 

	public:
		ConnectionForm();
		virtual ~ConnectionForm();

	public:
		void SetLayout();
		void DeleteMemory();
		void ReadConnectionInFile();
		void WriteConnectionToFile();	
		
	public slots:
		void SetEachWidget();
		void ClearEachWidget();
		void NewConnection();
		void NewConnectionOkButtonClick();
		void SaveConnection();
		int GetInformationInEachWidget(Information& information, QString& title);
		void OkButtonClicked();
		void CancelbuttonClick();
		void DeleteButtonClicked();

	protected:
		void closeEvent ( QCloseEvent * event );
		void keyPressEvent ( QKeyEvent * event );
		
	public:
		MainForm* GetMainForm() const;
		QPushButton* GetCancelButton() const;
		QPushButton* ClearButton() const;
		QPushButton* GetOkButton() const;
		QPushButton* GetNewButton() const;
		QPushButton* GetSaveButton() const;
		QPushButton* GetDeleteButton() const;

		QGroupBox* GetConnectGroup() const;
		QLabel* GetStoredConnectionLabel() const;
		QLabel* GetServerHostLabel() const;
		QLabel* GetUserNameLabel() const;
		QLabel*  GetPasswordLabel() const;
		QLabel* GetDatabaseLabel() const;
		QComboBox* GetStoredConnetionCombo() const;
		QToolButton* GetStoredConnectionButton() const;
		QLineEdit* GetServerHostEdit() const;
		QLineEdit* GetUserNameEdit() const;
		QLineEdit* GetPasswordEdit() const;
		QLineEdit* GetDatabaseEdit() const;
		QLineEdit* GetPortEdit() const;
		QLabel* GetPortLabel() const;
		SavedConnection* GetSavedConnection() const;
		QSqlDatabase* GetDb() const;

		void SetStateOfReconnect(bool state);

	public:
		/*
					̱  ...
		*/
		static ConnectionForm* getInstance()
		{
			if (uniqueInstance == NULL){
				uniqueInstance = new ConnectionForm();
			}
			return uniqueInstance;
		}

		//

	private:
		MainForm* mainForm;
		QPushButton *cancelButton;
		QPushButton *clearButton;
		QPushButton *okButton;

		QPushButton *newButton;
		QPushButton *saveButton;
		QPushButton *deleteButton;

		QGroupBox *connectGroup;
		QLabel *storedConnectionLabel;  
		QLabel *serverHostLabel;
		QLabel *userNameLabel;
		QLabel *passwordLabel;
		QLabel *databaseLabel;
		QComboBox *storedConnetionCombo;
		QToolButton *storedConnectionButton;
		QLineEdit *serverHostEdit;
		QLineEdit *userNameEdit;
		QLineEdit *passwordEdit;
		QLineEdit *databaseEdit;
		QLineEdit *portEdit;
		QLabel *portLabel;

		//  ̽  
		QSqlDatabase* db;

		QDialog* newConnection;

		SavedConnection* savedConnection;

		static ConnectionForm* uniqueInstance;

		bool stateOfReconnect;

};

// cancelButton  ϴ Լ
inline QPushButton* ConnectionForm::GetCancelButton() const
{
	return this->cancelButton;
}

// clearButton  ϴ Լ
inline QPushButton* ConnectionForm::ClearButton() const
{
	return this->clearButton;
}

// okButton  ϴ Լ
inline QPushButton* ConnectionForm::GetOkButton() const
{
	return this->okButton;
}

// newButton  ϴ Լ
inline QPushButton* ConnectionForm::GetNewButton() const
{
	return this->newButton;
}

// saveButton  ϴ Լ
inline QPushButton* ConnectionForm::GetSaveButton() const
{
	return this->saveButton;
}

// deleteButton  ϴ Լ
inline QPushButton* ConnectionForm::GetDeleteButton() const
{
	return this->deleteButton;
}

// connectGroup  ϴ Լ
inline QGroupBox* ConnectionForm::GetConnectGroup() const
{
	return this->connectGroup;
}

// storedConnectionLabel  ϴ Լ
inline QLabel* ConnectionForm::GetStoredConnectionLabel() const
{
	return this->storedConnectionLabel;
}

// serverHostLabel  ϴ Լ
inline QLabel* ConnectionForm::GetServerHostLabel() const
{
	return this->serverHostLabel;
}

// userNameLabel  ϴ Լ
inline QLabel* ConnectionForm::GetUserNameLabel() const
{
	return this->userNameLabel;
}

// passwordLabel  ϴ Լ
inline QLabel*  ConnectionForm::GetPasswordLabel() const
{
	return this->passwordLabel;
}

// databaseLabel  ϴ Լ
inline QLabel* ConnectionForm::GetDatabaseLabel() const
{
	return this->databaseLabel;
}

// storedConnetionCombo  ϴ Լ
inline QComboBox* ConnectionForm::GetStoredConnetionCombo() const
{
	return this->storedConnetionCombo;
}

// storedConnectionButton  ϴ Լ
inline QToolButton* ConnectionForm::GetStoredConnectionButton() const
{
	return this->storedConnectionButton;
}

// serverHostEdit  ϴ Լ
inline QLineEdit* ConnectionForm::GetServerHostEdit() const
{
	return this->serverHostEdit;
}

// userNameEdit  ϴ Լ
inline QLineEdit* ConnectionForm::GetUserNameEdit() const
{
	return this->userNameEdit;
}

// passwordEdit  ϴ Լ
inline QLineEdit* ConnectionForm::GetPasswordEdit() const
{
	return this->passwordEdit;
}

// databaseEdit  ϴ Լ
inline QLineEdit* ConnectionForm::GetDatabaseEdit() const
{
	return this->databaseEdit;
}

// portEdit  ϴ Լ
inline QLineEdit* ConnectionForm::GetPortEdit() const
{
	return this->portEdit;
}

// portLabel  ϴ Լ
inline QLabel* ConnectionForm::GetPortLabel() const
{
	return this->portLabel;
}

// savedConnection  ϴ Լ
inline SavedConnection* ConnectionForm::GetSavedConnection() const
{
	return const_cast<SavedConnection*>(this->savedConnection);
}

// db  ϴ Լ
inline QSqlDatabase* ConnectionForm::GetDb() const
{
	return const_cast<QSqlDatabase*>(this->db);
}

// mainForm  ϴ Լ
inline MainForm* ConnectionForm::GetMainForm() const
{
	return const_cast<MainForm*>(this->mainForm);
}

inline void ConnectionForm::SetStateOfReconnect(bool state)
{
	this->stateOfReconnect = state;
}

#endif // _CONNECTIONFORM_H
